<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\Contact;
use App\Models\Submenu;
use App\Models\Message;
use Illuminate\Support\Facades\Http;

use Illuminate\Support\Facades\Mail;
use App\Mail\sendMail;


class ContactController extends Controller
{
    public function index()
    {   $contact = Contact::first();
        $services = Submenu::where('menu_id','3')->get();
        // dd($service);
        return view('contact')->with('contact', $contact)
        ->with('services', $services);
    }

    public function store(Request $request)
    {  $contact = Contact::first();
        $data = request()->validate([
            'username' => 'required|min:4',
            'email' => 'required|email|max:100',
            'message' => 'required|string|max:255',
            'phone' => ['required', 'regex:/^(\+?|0)[1-9]\d{1,14}$/'],
            'service' => 'required',
        ]);

        // Save the contact message to the database or send an email
        $message= new Message;

        $message->username = $request->username;
        $message->email= $request->email;
        $message->mobile = $request->phone;
        $message->content = $request->message;
        $message->service_type = $request->service;

        $recaptchaResponse = $request->input('g-recaptcha-response');
        $secretKey = config('services.recaptcha.secret'); // Ensure this is set in config/services.php

        $response = Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify', [
            'secret' => $secretKey,
            'response' => $recaptchaResponse,
            'remoteip' => $request->ip(),
        ]);

        $responseBody = $response->json();

        if (!$responseBody['success']) {
            return back()->withErrors(['captcha' => 'ReCAPTCHA verification failed. Please try again.']);
        }

        if($message->save()){
            Mail::to('info@el-roi.com')->send(new SendMail($request->all(), $contact));

        return back()->with('success', 'Your message has been sent successfully!');
        }
    }
}


