<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/images/favicons/apple-touch-icon.png')); ?>" />
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/images/favicons/favicon-32x32.png')); ?>" />
    <link rel="icon" type="image/png" sizes="16x16"
        href="<?php echo e(asset('assets/images/favicons/favicon-16x16.png')); ?>" />
    <link rel="manifest" href="<?php echo e(asset('assets/images/favicons/site.webmanifest')); ?>" />
    <meta name="description" content="Insuz HTML 5 Template " />

    <!-- fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">

    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200;300;400;500;600;700;800&display=swap"
        rel="stylesheet">

    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900&display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/bootstrap/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/animate/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/animate/custom-animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/fontawesome/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/jarallax/jarallax.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/nouislider/nouislider.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/nouislider/nouislider.pips.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/odometer/odometer.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/swiper/swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/insuz-icons/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/tiny-slider/tiny-slider.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/reey-font/stylesheet.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/owl-carousel/owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/owl-carousel/owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/bxslider/jquery.bxslider.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/bootstrap-select/css/bootstrap-select.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/vegas/vegas.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/jquery-ui/jquery-ui.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/timepicker/timePicker.css')); ?>" />

    <!-- template styles -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/insuz.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/insuz-responsive.css')); ?>" />

    
      <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/owl-carousel/css/owl.carousel.min.css')); ?>" />
</head>

<body>




    <div class="preloader">
        <div class="preloader__image"></div>
    </div>
    <!-- /.preloader -->



    <div class="page-wrapper">
        <header class="main-header">
            <div class="main-header__top">
                <div class="main-header__top-wrapper">
                    <div class="main-header__top-inner">
                        <div class="main-header__top-left">
                            <div class="main-header__top-review-social">
                                <div class="main-header__top-review-box">
                                    <span class="icon-star"></span>
                                    <p class="main-header__top-review">( 3 223 Reviews )
                                    </p>
                                </div>
                                <div class="main-header__top-social">
                                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                                    <a href="#"><i class="fab fa-twitter"></i></a>
                                    <a href="#"><i class="fab fa-pinterest-p"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="main-header__top-right">
                            <ul class="list-unstyled main-header__address-list">
                                <li>
                                    <div class="icon">
                                        <span class="icon-clock"></span>
                                    </div>
                                    <div class="content">
                                        <p><?php echo e($contact->opening_time); ?></p>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon">
                                        <span class="icon-envelope"></span>
                                    </div>
                                    <div class="content">
                                        <p><a href="mailto:h<?php echo e($contact->email); ?>"><?php echo e($contact->email); ?></a></p>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <nav class="main-menu">
                <div class="main-menu__wrapper">
                    <div class="main-menu__wrapper-inner">
                        <div class="main-menu__logo">
                            <a href="<?php echo e(url('/')); ?>"><img
                                    src="<?php echo e(asset('assets/images/resources/NLIP-logo2.png')); ?>" style="width: 250px;"
                                    alt=""></a>
                        </div>
                        <div class="main-menu__main-menu-box">
                            <div class="main-menu__main-menu-box-left"
                                style=" border-top-left-radius: 50rem; border-bottom-left-radius: 50rem; border-top-right-radius: 0; border-bottom-right-radius: 0;">
                                <a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
                                <ul class="main-menu__list">
                                    <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="dropdown">
                                            <a href="<?php echo e(url('/')); ?>"><?php echo e(Str::ucfirst($menu->name)); ?> </a>

                                            <?php if(count($menu->submenus) > 1): ?>
                                                <ul>
                                                    <?php $__currentLoopData = $menu->submenus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><a
                                                                href="<?php echo e(url('/' . $submenu->id)); ?>"><?php echo e($submenu->name); ?></a>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    
                                    </li>
                                    
                                </ul>
                            </div>
                            <div class="main-menu__main-menu-box-right">
                                <div class="main-menu__call">
                                    <div class="main-menu__call-icon">
                                        <span class="icon-phone"></span>
                                    </div>
                                    <div class="main-menu__call-content">
                                        <h5 class="main-menu__call-sub-title">Quick Call</h5>
                                        <p class="main-menu__call-number"><a
                                                href="tel:<?php echo e($contact->mobile); ?>"><?php echo e($contact->mobile); ?></a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="main-menu__right">
                            <div class="main-menu__search-box">
                                <form action="#" class="main-menu__search-form">
                                    <input type="search" placeholder="Search keword">
                                    <button type="submit"><i class="icon-search"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </header>

        <div class="stricky-header stricked-menu main-menu">
            <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
        </div><!-- /.stricky-header -->

        

                <section class="main-slider-three">
            
            <div class="main-slider-three__carousel modins-owl__carousel owl-carousel"
                data-owl-options='{
                "loop": true,
                "animateOut": "fadeOut",
                "animateIn": "fadeIn",
                "items": 1,
                "autoplay": true,
                "autoplayTimeout": 7000,
                "smartSpeed": 1000,
                "nav": true,
                "navText": ["<span class=\"icon-left-arrow\"></span>","<span class=\"icon-right-arrow\"></span>"],
                "dots": false,
                "margin": 0
            }'>
                <div class="item">
                    <div class="main-slider-three__item">
                        <div class="main-slider-one__bg"
                            style="background-image: url(<?php echo e(asset('assets/images/backgrounds/male-driver-with-whiplash-injury-calls-car-insuran-2024-12-04-12-40-56-utc.jpg')); ?>);">
                        </div>
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider-three__wrap">
                                        <div class="main-slider-three__content">
                                            <h2 class="display-5 mb-4"><span
                                                    class="bg-white rounded p-2 ">Professional Protection You Can
                                                </span> </h2><span class="bg-white m-2 display-6 p-2"
                                                style="color:#003CE9; font-weight:bold;"><b>Count On—Every Hour, Every
                                                    Day.</b></span>
                                            <div class="main-slider-three__btn mt-5">
                                                <a href="<?php echo e(url('services.html')); ?>"
                                                    class="modins-btn modins-btn--base  rounded"><span>Let’s Get
                                                        Started</span> <em></em></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="item">
                    <div class="main-slider-three__item">
                        <div class="main-slider-one__bg">
                            <video autoplay muted loop style="width: 100%; height: auto;">
                                <source
                                    src="<?php echo e(asset('assets/videos/serious-african-security-guard-and-business-people-2023-11-27-05-26-31-utc.mp4')); ?>"
                                    type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                        </div>
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider-three__wrap">
                                        <div class="main-slider-three__content">
                                            <h2 class="" style="color:#ffffff; font-weight:bold;">Delivering
                                                Elite Security Solutions</h2>
                                            <div class="main-slider-three__btn ">
                                                <a href="<?php echo e(url('services.html')); ?>"
                                                    class="modins-btn modins-btn--base rounded"><span>Let’s Get
                                                        Started</span> <em></em></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


    </div>

    <div class="swiper-pagination" id="main-slider-pagination"></div>

    <!-- If we need navigation buttons -->


    </div>
    </section>
    <!--Main Slider End-->


    <?php echo $__env->yieldContent('content'); ?>




    <!--Site Footer Start-->
    <footer class="site-footer">
        <div class="site-footer-shape-1 float-bob-y">
            <img src="<?php echo e(asset('assets/images/shapes/site-footer-shape-1.png')); ?>" alt="">
        </div>
        <div class="site-footer-shape-2 float-bob-y">
            <img src="<?php echo e(asset('assets/images/shapes/site-footer-shape-2.png')); ?>" alt="">
        </div>
        <div class="site-footer-shape-3 float-bob-x">
            <img src="<?php echo e(asset('assets/images/shapes/site-footer-shape-3.png')); ?>" alt="">
        </div>
        <div class="site-footer-shape-4 float-bob-x">
            <img src="<?php echo e(asset('assets/images/shapes/site-footer-shape-4.png')); ?>" alt="">
        </div>
        <div class="site-footer-shape-5 zoom-fade">
            <img src="<?php echo e(asset('assets/images/shapes/site-footer-shape-5.png')); ?>" alt="">
        </div>
        <div class="site-footer-shape-6 zoominout">
            <img src="<?php echo e(asset('assets/images/shapes/site-footer-shape-6.png')); ?>" alt="">
        </div>
        <div class="site-footer-shape-7 float-bob-x">
            <img src="<?php echo e(asset('assets/images/shapes/site-footer-shape-7.png')); ?>" alt="">
        </div>
        <div class="site-footer__top">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="100ms">
                        <div class="footer-widget__column footer-widget__contact-box">
                            <div class="footer-widget__logo-box">
                                <div class="footer-widget__logo">
                                    <a href="index.html"><img
                                            src="<?php echo e(asset('assets/images/resources/footer-logo.png')); ?>"
                                            alt=""></a>
                                </div>
                            </div>
                            <ul class="footer-widget__contact list-unstyled">
                                <li>
                                    <div class="icon">
                                        <i class="icon-phone"></i>
                                    </div>
                                    <div class="text">
                                        <p>
                                            <a href="tel:<?php echo e($contact->mobile); ?>"><?php echo e($contact->mobile); ?></a>
                                            
                                        </p>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon icon-two">
                                        <i class="icon-location"></i>
                                    </div>
                                    <div class="text">
                                        <p><?php echo e($contact->address); ?></p>
                                    </div>
                                </li>
                            </ul>
                            <ul class="footer-widget__social-box list-unstyled">
                                <li>
                                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-twitter"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-pinterest-p"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-instagram"></i></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="200ms">
                        <div class="footer-widget__latest-post">
                            <div class="footer-widget__title-box">
                                <h4 class="footer-widget__title">Latest Post</h4>
                            </div>
                            <ul class="footer-widget__latest-post-list list-unstyled">
                                <li>
                                    <div class="footer-widget__latest-post-img">
                                        <img src="<?php echo e(asset('assets/images/resources/footer-widget__latest-post-img-1.jpg')); ?>"
                                            alt="">
                                    </div>
                                    <div class="footer-widget__latest-post-content">
                                        <p class="footer-widget__latest-post-date">30 August 2022</p>
                                        <h5 class="footer-widget__latest-post-title"><a href="blog-details.html">How
                                                Much Does It
                                                Cost to
                                                Remodel a Shower?</a></h5>
                                    </div>
                                </li>
                                <li>
                                    <div class="footer-widget__latest-post-img">
                                        <img src="assets/images/resources/footer-widget__latest-post-img-2.jpg"
                                            alt="">
                                    </div>
                                    <div class="footer-widget__latest-post-content">
                                        <p class="footer-widget__latest-post-date">30 August 2022</p>
                                        <h5 class="footer-widget__latest-post-title"><a href="blog-details.html">5
                                                ways to take the
                                                bite out of pension regret</a></h5>
                                    </div>
                                </li>
                                <li>
                                    <div class="footer-widget__latest-post-img">
                                        <img src="assets/images/resources/footer-widget__latest-post-img-3.jpg"
                                            alt="">
                                    </div>
                                    <div class="footer-widget__latest-post-content">
                                        <p class="footer-widget__latest-post-date">30 August 2022</p>
                                        <h5 class="footer-widget__latest-post-title"><a href="blog-details.html">Tip
                                                up your
                                                workplace
                                                wellbeing scales</a></h5>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="300ms">
                        <div class="footer-widget__services">
                            <div class="footer-widget__title-box">
                                <h4 class="footer-widget__title">Services</h4>
                            </div>
                            <ul class="footer-widget__services-list list-unstyled">
                                <li><a href="insurance.html">Car Insurance</a></li>
                                <li><a href="insurance2.html">Investment</a></li>
                                <li><a href="about.html">Mediclaim Policy</a></li>
                                <li><a href="insurance.html">Health Insurance</a></li>
                                <li><a href="insurance.html">Life Insurance</a></li>
                                <li><a href="about.html">Mission Statement</a></li>
                                <li><a href="about.html">About us</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="400ms">
                        <div class="footer-widget__newsletter">
                            <div class="footer-widget__title-box">
                                <h4 class="footer-widget__title">Newsletter</h4>
                            </div>
                            <p class="footer-widget__text">Get the latest news, tips and latest messages, including
                                special offers</p>
                            <form class="footer-widget__subscribe-box">
                                <div class="footer-widget__subscribe-input-box">
                                    <input type="email" placeholder="Email Address" name="email">
                                    <button type="submit" class="footer-widget__subscribe-btn"><i
                                            class="icon-send"></i></button>
                                </div>
                            </form>
                            <div class="footer-widget__help">
                                <div class="icon">
                                    <span class="icon-envelope"></span>
                                </div>
                                <div class="footer-widget__help-text">
                                    <p class="text-nowrap"><a
                                            href="mailto:<?php echo e($contact->email); ?>"><?php echo e($contact->email); ?></a></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="site-footer__bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="site-footer__bottom-inner">
                            <p class="site-footer__bottom-text">©<?php echo date('Y'); ?> NLIP All Rights Reserved</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!--Site Footer End-->


    </div><!-- /.page-wrapper -->


    <div class="mobile-nav__wrapper">
        <div class="mobile-nav__overlay mobile-nav__toggler"></div>
        <!-- /.mobile-nav__overlay -->
        <div class="mobile-nav__content">
            <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

            <div class="logo-box">
                <a href="index.html" aria-label="logo image"><img
                        src="<?php echo e(asset('assets/images/resources/logo-2.png')); ?>" width="150" alt="" /></a>
            </div>
            <!-- /.logo-box -->
            <div class="mobile-nav__container"></div>
            <!-- /.mobile-nav__container -->

            <ul class="mobile-nav__contact list-unstyled">
                <li>
                    <i class="fa fa-envelope"></i>
                    <a href="mailto:<?php echo e($contact->email); ?>"><?php echo e($contact->email); ?></a>
                </li>
                <li>
                    <i class="fa fa-phone-alt"></i>
                    <a href="<?php echo e($contact->mobile); ?>"><?php echo e($contact->mobile); ?></a>
                </li>
            </ul><!-- /.mobile-nav__contact -->
            <div class="mobile-nav__top">
                <div class="mobile-nav__social">
                    <a href="#" class="fab fa-twitter"></a>
                    <a href="#" class="fab fa-facebook-square"></a>
                    <a href="#" class="fab fa-pinterest-p"></a>
                    <a href="#" class="fab fa-instagram"></a>
                </div><!-- /.mobile-nav__social -->
            </div><!-- /.mobile-nav__top -->



        </div>
        <!-- /.mobile-nav__content -->
    </div>
    <!-- /.mobile-nav__wrapper -->

    <div class="search-popup">
        <div class="search-popup__overlay search-toggler"></div>
        <!-- /.search-popup__overlay -->
        <div class="search-popup__content">
            <form action="#">
                <label for="search" class="sr-only">search here</label><!-- /.sr-only -->
                <input type="text" id="search" placeholder="Search Here..." />
                <button type="submit" aria-label="search submit" class="thm-btn">
                    <i class="icon-search"></i>
                </button>
            </form>
        </div>
        <!-- /.search-popup__content -->
    </div>
    <!-- /.search-popup -->

    <a href="#" data-target="html" class="scroll-to-target scroll-to-top"><i class="fa fa-angle-up"></i></a>

    <script src="<?php echo e(asset('assets/vendors/jquery/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jarallax/jarallax.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-appear/jquery.appear.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-validate/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/nouislider/nouislider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/odometer/odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/swiper/swiper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/tiny-slider/tiny-slider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/wnumb/wNumb.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/wow/wow.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/isotope/isotope.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/countdown/countdown.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/bxslider/jquery.bxslider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/bootstrap-select/js/bootstrap-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/vegas/vegas.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/jquery-ui/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/timepicker/timePicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/circleType/jquery.circleType.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/circleType/jquery.lettering.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/sidebar-content/jquery-sidebar-content.js')); ?>"></script>




    <!-- template js -->
    <script src="<?php echo e(asset('assets/js/insuz.js')); ?>"></script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\nlipwebsite\resources\views\layouts\master.blade.php ENDPATH**/ ?>