<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>@yield('title')</title>
    <!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/images/favicons/NLIP-fav.png') }}" />
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('assets/images/favicons/NLIP-32x32.png') }}" />
    <link rel="icon" type="image/png" sizes="16x16"
        href="{{ asset('assets/images/favicons/NLIP-16x16.png') }}" />
    <link rel="manifest" href="{{ asset('assets/images/favicons/site.webmanifest') }}" />
    <meta name="description" content="Insuz HTML 5 Template " />

    <!-- fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">

    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200;300;400;500;600;700;800&display=swap"
        rel="stylesheet">

    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900&display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="{{ asset('assets/vendors/bootstrap/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/animate/animate.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/animate/custom-animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/fontawesome/css/all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/jarallax/jarallax.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/nouislider/nouislider.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/nouislider/nouislider.pips.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/odometer/odometer.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/swiper/swiper.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/insuz-icons/style.css') }}">
    {{-- <link rel="stylesheet" href="{{ asset('assets/vendors/arkuz-icons/style.css') }}" /> --}}
    <link rel="stylesheet" href="{{ asset('assets/vendors/tiny-slider/tiny-slider.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/reey-font/stylesheet.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/owl-carousel/owl.carousel.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/owl-carousel/owl.theme.default.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/bxslider/jquery.bxslider.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/bootstrap-select/css/bootstrap-select.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/vegas/vegas.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/jquery-ui/jquery-ui.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/timepicker/timePicker.css') }}" />

    <!-- template styles -->
    <link rel="stylesheet" href="{{ asset('assets/css/insuz.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/insuz-responsive.css') }}" />

    {{-- for slider --}}
    <link rel="stylesheet" href="{{ asset('assets/vendors/owl-carousel/css/owl.carousel.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/vendors/owl-carousel/css/owl.theme.default.min.css') }}" />
    {{-- arkuz css --}}
    <link rel="stylesheet" href="{{ asset('assets/css/arkuz.css') }}" />
</head>

<body>




    <div class="preloader">
        <div class="preloader__image"></div>
    </div>
    <!-- /.preloader -->



    <div class="page-wrapper">
        <header class="main-header">
            <div class="main-header__top">
                <div class="main-header__top-wrapper">
                    <div class="main-header__top-inner">
                        <div class="main-header__top-left">
                            <div class="main-header__top-review-social">
                                <div class="main-header__top-review-box">
                                    <span class="icon-star"></span>
                                    <p class="main-header__top-review">( 3 223 Reviews )
                                    </p>
                                </div>
                                <div class="main-header__top-social">
                                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                                    <a href="#"><i class="fab fa-twitter"></i></a>
                                    <a href="#"><i class="fab fa-pinterest-p"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="main-header__top-right">
                            <ul class="list-unstyled main-header__address-list">
                                <li>
                                    <div class="icon">
                                        <span class="icon-clock"></span>
                                    </div>
                                    <div class="content">
                                        <p>{{ $contact->opening_time }}</p>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon">
                                        <span class="icon-envelope"></span>
                                    </div>
                                    <div class="content">
                                        <p><a href="mailto:h{{ $contact->email }}">{{ $contact->email }}</a></p>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <nav class="main-menu">
                <div class="main-menu__wrapper">
                    <div class="main-menu__wrapper-inner">
                        <div class="main-menu__logo">
                            <a href="{{ url('/') }}"><img
                                    src="{{ asset('assets/images/resources/NLIP-logo2.png') }}" style="width: 250px;"
                                    alt=""></a>
                        </div>
                        <div class="main-menu__main-menu-box">
                            <div class="main-menu__main-menu-box-left"
                                style=" border-top-left-radius: 50rem; border-bottom-left-radius: 50rem; border-top-right-radius: 0; border-bottom-right-radius: 0;">
                                <a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
                                <ul class="main-menu__list">
                                    @foreach ($menus as $menu)
                                        <li class="dropdown">
                                            <a href="{{ url('/') }}">{{ Str::ucfirst($menu->name) }} </a>

                                            @if (count($menu->submenus) > 1)
                                                <ul>
                                                    @foreach ($menu->submenus as $submenu)
                                                        <li><a
                                                                href="{{ url('/' . $submenu->id) }}">{{ $submenu->name }}</a>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            @endif
                                    @endforeach

                                    {{-- <ul>
                                            <li><a href="{{ url('/') }}">Home One</a></li>
                                            <li><a href="{{ url('/index2') }}">Home Two</a></li>
                                            <li><a href="{{ url('/index3') }}">Home Three</a></li>
                                            <li class="dropdown">
                                                <a href="#">Header Styles</a>
                                                <ul>
                                                    <li><a href="{{ url('/') }}">Header One</a></li>
                                                    <li><a href="{{ url('/index2') }}">Header Two</a></li>
                                                    <li><a href="{{ url('/index3') }}">Header Three</a></li>
                                                </ul>
                                            </li>
                                        </ul> --}}
                                    </li>
                                    {{-- <li class="dropdown">
                                        <a href="#">Portfolio</a>
                                        <ul>
                                            <li><a href="{{ url('/portfolio') }}">Portfolio</a></li>
                                            <li><a href="{{ url('/portfolio-details') }}">Portfolio Details</a></li>
                                        </ul>
                                    </li>
                                    <li class="dropdown">
                                        <a href="#">Insurance</a>
                                        <ul>
                                            <li><a href="{{ url('/insurance') }}">Insurance V-1</a></li>
                                            <li><a href="{{ url('/insurance2') }}">Insurance V-2</a></li>
                                            <li><a href="{{ url('/insurance-details') }}">Insurance Details</a></li>
                                        </ul>
                                    </li>
                                    <li class="dropdown">
                                        <a href="#">Page</a>
                                        <ul>
                                            <li><a href="{{ url('/about') }}">About</a></li>
                                            <li><a href="{{ url('/team') }}">Team</a></li>
                                            <li><a href="{{ url('/testimonial') }}">Testimonial</a></li>
                                            <li><a href="{{ url('/faq') }}">FAQs</a></li>
                                            <li><a href="{{ url('/404') }}">404 Error</a></li>
                                        </ul>
                                    </li>
                                    <li class="dropdown">
                                        <a href="#">Blog</a>
                                        <ul>
                                            <li><a href="{{ url('/blog') }}">Blog</a></li>
                                            <li><a href="{{ url('/blog-list') }}">Blog List</a></li>
                                            <li><a href="{{ url('/blog-details') }}">Blog Details</a></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <a href="{{ url('/contact') }}">Contact</a>
                                    </li> --}}
                                </ul>
                            </div>
                            <div class="main-menu__main-menu-box-right">
                                <div class="main-menu__call">
                                    <div class="main-menu__call-icon">
                                        <span class="icon-phone"></span>
                                    </div>
                                    <div class="main-menu__call-content">
                                        <h5 class="main-menu__call-sub-title">Quick Call</h5>
                                        <p class="main-menu__call-number"><a
                                                href="tel:{{ $contact->mobile }}">{{ $contact->mobile }}</a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="main-menu__right">
                            <div class="main-menu__search-box">
                                <form action="#" class="main-menu__search-form">
                                    <input type="search" placeholder="Search keword">
                                    <button type="submit"><i class="icon-search"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </header>

        <div class="stricky-header stricked-menu main-menu">
            <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
        </div><!-- /.stricky-header -->

        {{-- <div class="swiper-slide">
            <div class="image-layer"
                style="background-image: url({{ asset('assets/images/backgrounds/male-driver-with-whiplash-injury-calls-car-insuran-2024-12-04-12-40-56-utc.jpg') }});">
            </div>
            <!-- /.image-layer -->

            <div class="main-slider__shape-1">
                <img src="{{ asset('assets/images/shapes/main-slider-shape-1-1.png') }}" alt="">
            </div>
            <div class="{{ asset('main-slider__shape-2 float-bob-y') }}">
                <img src="{{ asset('assets/images/shapes/main-slider-shape-2.png') }}" alt="">
            </div>
            <div class="main-slider__shape-3 float-bob-x">
                <img src="{{ asset('assets/images/shapes/main-slider-shape-3.png') }}" alt="">
            </div>

            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="main-slider__content">
                            <h2 class="main-slider__title text-dark">Every single <br> thing for your <br> future
                                <span>HOME</span>
                            </h2>
                            <p class="main-slider__text  text-dark">Give your finances the good spring clean they
                                deserve. Savings and Investments</p>
                            <div class="main-slider__btn-box">
                                <a href="about.html" class="main-slider__btn  text-dark">Get started offer</a>
                            </div>
                            <div class="main-slider__video-link">
                                <a href="#" class="video-popup">
                                    <div class="main-slider__video-icon">
                                        <span class="icon-play-of-right-arrow-triangle"></span>
                                        <i class="ripple"></i>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}

        <section class="main-slider-three">

            <div class="main-slider-three__carousel modins-owl__carousel owl-carousel"
                data-owl-options='{
                "loop": true,
                "animateOut": "fadeOut",
                "animateIn": "fadeIn",
                "items": 1,
                "autoplay": true,
                "autoplayTimeout": 7000,
                "smartSpeed": 7000,
                "nav": true,
                "navText": ["<span class=\"icon-left-arrow\"></span>","<span class=\"icon-right-arrow\"></span>"],
                "dots": false,
                "margin": 0
            }'>
                <div class="item">
                    <div class="main-slider-three__item">
                        <div class="main-slider-one__bg"
                            style="background-image: url({{ asset('assets/images/backgrounds/male-driver-with-whiplash-injury-calls-car-insuran-2024-12-04-12-40-56-utc.jpg') }});">
                        </div>
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider-three__wrap">
                                        <div class="main-slider-three__content text-center">
                                            <h2 class="display-5 mb-4 wow fadeInDown" data-wow-delay="0.2s">
                                                <span class="rounded p-2 d-inline-block" style="background-color:rgba(255,255,255,0.7) !important;">
                                                    <span class="" style="font-weight:700;color:#FF9D00">
                                                        <span class="typewrite" data-period="2000" data-type='[ "Professional Protection", "Trusted Coverage", "Peace of Mind" ]'>
                                                            <span class="wrap"></span>
                                                        </span>
                                                    </span>
                                                    You Can Count On
                                                </span>
                                            </h2>
                                            <span class="bg-white m-2 display-6 p-2 wow fadeInUp" data-wow-delay="0.6s"
                                                style="color:#FF9D00; font-weight:bold;background-color:rgba(255,255,255,0.7) !important;">
                                                <b>—Every Hour, Every Day.</b>
                                            </span>
                                            <div class="main-slider-three__btn mt-5 wow zoomIn" data-wow-delay="1s" style="position:relative; top:-10px;">
                                                <a href="{{ url('services.html') }}"
                                                    class="modins-btn modins-btn--base rounded shadow-lg ">
                                                    <span>Let’s Get Started</span> <em></em>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="main-slider-three__item">
                        <div class="main-slider-one__bg"
                            style="background-image: url({{ asset('assets/images/backgrounds/two-people-in-safety-vests-and-hard-hats-stand-out-2025-02-09-08-30-59-utc1.jpg') }});">
                        </div>
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider-three__wrap">
                                        <div class="main-slider-three__content text-center">
                                            <h2 class="display-5 mb-4 wow fadeInDown" data-wow-delay="0.2s">
                                                <span class="rounded p-2 d-inline-block" style="background-color:rgba(255,255,255,0.7) !important;">
                                                    <span class="" style="font-weight:700;color:#FF9D00">
                                                        <span class="typewrite" data-period="2000" data-type='[ "Professional Protection", "Trusted Coverage", "Peace of Mind" ]'>
                                                            <span class="wrap"></span>
                                                        </span>
                                                    </span>
                                                    You Can Count On
                                                </span>
                                            </h2>
                                            <span class="bg-white m-2 display-6 p-2 wow fadeInUp" data-wow-delay="0.6s"
                                                style="color:#FF9D00; font-weight:bold;background-color:rgba(255,255,255,0.7) !important;">
                                                <b>—Every Hour, Every Day.</b>
                                            </span>
                                            <div class="main-slider-three__btn mt-5 wow zoomIn" data-wow-delay="1s" style="position:relative; top:-10px;">
                                                <a href="{{ url('services.html') }}"
                                                    class="modins-btn modins-btn--base rounded shadow-lg ">
                                                    <span>Let’s Get Started</span> <em></em>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <script>
                // Typewriter effect for headline
                document.addEventListener("DOMContentLoaded", function() {
                    var elements = document.getElementsByClassName('typewrite');
                    for (var i=0; i<elements.length; i++) {
                        var toRotate = elements[i].getAttribute('data-type');
                        var period = elements[i].getAttribute('data-period');
                        if (toRotate) {
                            new TxtType(elements[i], JSON.parse(toRotate), period);
                        }
                    }
                });

                function TxtType(el, toRotate, period) {
                    this.toRotate = toRotate;
                    this.el = el;
                    this.loopNum = 0;
                    this.period = parseInt(period, 10) || 2000;
                    this.txt = '';
                    this.isDeleting = false;
                    this.tick();
                }

                TxtType.prototype.tick = function() {
                    var i = this.loopNum % this.toRotate.length;
                    var fullTxt = this.toRotate[i];

                    if (this.isDeleting) {
                        this.txt = fullTxt.substring(0, this.txt.length - 1);
                    } else {
                        this.txt = fullTxt.substring(0, this.txt.length + 1);
                    }

                    this.el.querySelector('.wrap').innerHTML = this.txt;

                    var that = this;
                    var delta = 150 - Math.random() * 100;

                    if (this.isDeleting) { delta /= 2; }

                    if (!this.isDeleting && this.txt === fullTxt) {
                        delta = this.period;
                        this.isDeleting = true;
                    } else if (this.isDeleting && this.txt === '') {
                        this.isDeleting = false;
                        this.loopNum++;
                        delta = 500;
                    }

                    setTimeout(function() {
                        that.tick();
                    }, delta);
                };
                </script>
        </section>


    <div class="swiper-pagination" id="main-slider-pagination"></div>

    <!-- If we need navigation buttons -->


    </div>
    </section>
    <!--Main Slider End-->


    @yield('content')




    <!--Site Footer Start-->
    <footer class="site-footer">
        <div class="site-footer-shape-1 float-bob-y">
            <img src="{{ asset('assets/images/shapes/site-footer-shape-1.png') }}" alt="">
        </div>
        <div class="site-footer-shape-2 float-bob-y">
            <img src="{{ asset('assets/images/shapes/site-footer-shape-2.png') }}" alt="">
        </div>
        <div class="site-footer-shape-3 float-bob-x">
            <img src="{{ asset('assets/images/shapes/site-footer-shape-3.png') }}" alt="">
        </div>
        <div class="site-footer-shape-4 float-bob-x">
            <img src="{{ asset('assets/images/shapes/site-footer-shape-4.png') }}" alt="">
        </div>
        <div class="site-footer-shape-5 zoom-fade">
            <img src="{{ asset('assets/images/shapes/site-footer-shape-5.png') }}" alt="">
        </div>
        <div class="site-footer-shape-6 zoominout">
            <img src="{{ asset('assets/images/shapes/site-footer-shape-6.png') }}" alt="">
        </div>
        <div class="site-footer-shape-7 float-bob-x">
            <img src="{{ asset('assets/images/shapes/site-footer-shape-7.png') }}" alt="">
        </div>
        <div class="site-footer__top">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="100ms">
                        <div class="footer-widget__column footer-widget__contact-box">
                            <div class="footer-widget__logo-box">
                                <div class="footer-widget__logo">
                                    <a href="index.html"><img
                                            src="{{ asset('assets/images/resources/footer-logo.png') }}"
                                            alt=""></a>
                                </div>
                            </div>
                            <ul class="footer-widget__contact list-unstyled">
                                <li>
                                    <div class="icon">
                                        <i class="icon-phone"></i>
                                    </div>
                                    <div class="text">
                                        <p>
                                            <a href="tel:{{ $contact->mobile }}">{{ $contact->mobile }}</a>
                                            {{-- <a href="tel:86611220077">+866 11 22 00 77</a> --}}
                                        </p>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon icon-two">
                                        <i class="icon-location"></i>
                                    </div>
                                    <div class="text">
                                        <p>{{ $contact->address }}</p>
                                    </div>
                                </li>
                            </ul>
                            <ul class="footer-widget__social-box list-unstyled">
                                <li>
                                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-twitter"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-pinterest-p"></i></a>
                                </li>
                                <li>
                                    <a href="#"><i class="fab fa-instagram"></i></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="200ms">
                        <div class="footer-widget__latest-post">
                            <div class="footer-widget__title-box">
                                <h4 class="footer-widget__title">Latest Post</h4>
                            </div>
                            <ul class="footer-widget__latest-post-list list-unstyled">
                                <li>
                                    <div class="footer-widget__latest-post-img">
                                        <img src="{{ asset('assets/images/resources/footer-widget__latest-post-img-1.jpg') }}"
                                            alt="">
                                    </div>
                                    <div class="footer-widget__latest-post-content">
                                        <p class="footer-widget__latest-post-date">30 August 2022</p>
                                        <h5 class="footer-widget__latest-post-title"><a href="blog-details.html">How
                                                Much Does It
                                                Cost to
                                                Remodel a Shower?</a></h5>
                                    </div>
                                </li>
                                <li>
                                    <div class="footer-widget__latest-post-img">
                                        <img src="assets/images/resources/footer-widget__latest-post-img-2.jpg"
                                            alt="">
                                    </div>
                                    <div class="footer-widget__latest-post-content">
                                        <p class="footer-widget__latest-post-date">30 August 2022</p>
                                        <h5 class="footer-widget__latest-post-title"><a href="blog-details.html">5
                                                ways to take the
                                                bite out of pension regret</a></h5>
                                    </div>
                                </li>
                                <li>
                                    <div class="footer-widget__latest-post-img">
                                        <img src="assets/images/resources/footer-widget__latest-post-img-3.jpg"
                                            alt="">
                                    </div>
                                    <div class="footer-widget__latest-post-content">
                                        <p class="footer-widget__latest-post-date">30 August 2022</p>
                                        <h5 class="footer-widget__latest-post-title"><a href="blog-details.html">Tip
                                                up your
                                                workplace
                                                wellbeing scales</a></h5>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="300ms">
                        <div class="footer-widget__services">
                            <div class="footer-widget__title-box">
                                <h4 class="footer-widget__title">Services</h4>
                            </div>
                            <ul class="footer-widget__services-list list-unstyled">
                                <li><a href="insurance.html">Car Insurance</a></li>
                                <li><a href="insurance2.html">Investment</a></li>
                                <li><a href="about.html">Mediclaim Policy</a></li>
                                <li><a href="insurance.html">Health Insurance</a></li>
                                <li><a href="insurance.html">Life Insurance</a></li>
                                <li><a href="about.html">Mission Statement</a></li>
                                <li><a href="about.html">About us</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="400ms">
                        <div class="footer-widget__newsletter">
                            <div class="footer-widget__title-box">
                                <h4 class="footer-widget__title">Newsletter</h4>
                            </div>
                            <p class="footer-widget__text">Get the latest news, tips and latest messages, including
                                special offers</p>
                            <form class="footer-widget__subscribe-box">
                                <div class="footer-widget__subscribe-input-box">
                                    <input type="email" placeholder="Email Address" name="email">
                                    <button type="submit" class="footer-widget__subscribe-btn"><i
                                            class="icon-send"></i></button>
                                </div>
                            </form>
                            <div class="footer-widget__help">
                                <div class="icon">
                                    <span class="icon-envelope"></span>
                                </div>
                                <div class="footer-widget__help-text">
                                    <p class="text-nowrap"><a
                                            href="mailto:{{ $contact->email }}">{{ $contact->email }}</a></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="site-footer__bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="site-footer__bottom-inner">
                            <p class="site-footer__bottom-text">©@php echo date('Y'); @endphp NLIP All Rights Reserved</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!--Site Footer End-->


    </div><!-- /.page-wrapper -->


    <div class="mobile-nav__wrapper">
        <div class="mobile-nav__overlay mobile-nav__toggler"></div>
        <!-- /.mobile-nav__overlay -->
        <div class="mobile-nav__content">
            <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

            <div class="logo-box">
                <a href="index.html" aria-label="logo image"><img
                        src="{{ asset('assets/images/resources/logo-2.png') }}" width="150" alt="" /></a>
            </div>
            <!-- /.logo-box -->
            <div class="mobile-nav__container"></div>
            <!-- /.mobile-nav__container -->

            <ul class="mobile-nav__contact list-unstyled">
                <li>
                    <i class="fa fa-envelope"></i>
                    <a href="mailto:{{ $contact->email }}">{{ $contact->email }}</a>
                </li>
                <li>
                    <i class="fa fa-phone-alt"></i>
                    <a href="{{ $contact->mobile }}">{{ $contact->mobile }}</a>
                </li>
            </ul><!-- /.mobile-nav__contact -->
            <div class="mobile-nav__top">
                <div class="mobile-nav__social">
                    <a href="#" class="fab fa-twitter"></a>
                    <a href="#" class="fab fa-facebook-square"></a>
                    <a href="#" class="fab fa-pinterest-p"></a>
                    <a href="#" class="fab fa-instagram"></a>
                </div><!-- /.mobile-nav__social -->
            </div><!-- /.mobile-nav__top -->



        </div>
        <!-- /.mobile-nav__content -->
    </div>
    <!-- /.mobile-nav__wrapper -->

    <div class="search-popup">
        <div class="search-popup__overlay search-toggler"></div>
        <!-- /.search-popup__overlay -->
        <div class="search-popup__content">
            <form action="#">
                <label for="search" class="sr-only">search here</label><!-- /.sr-only -->
                <input type="text" id="search" placeholder="Search Here..." />
                <button type="submit" aria-label="search submit" class="thm-btn">
                    <i class="icon-search"></i>
                </button>
            </form>
        </div>
        <!-- /.search-popup__content -->
    </div>
    <!-- /.search-popup -->

    <a href="#" data-target="html" class="scroll-to-target scroll-to-top"><i class="fa fa-angle-up"></i></a>

    <script src="{{ asset('assets/vendors/jquery/jquery-3.6.0.min.js') }}"></script>
    {{-- <script src="{{ asset('assets/vendors/jquery/jquery-3.7.0.min.js') }}"></script> --}}
    <script src="{{ asset('assets/vendors/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/jarallax/jarallax.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/jquery-appear/jquery.appear.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/jquery-validate/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/nouislider/nouislider.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/odometer/odometer.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/swiper/swiper.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/tiny-slider/tiny-slider.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/wnumb/wNumb.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/wow/wow.js') }}"></script>
    <script src="{{ asset('assets/vendors/isotope/isotope.js') }}"></script>
    <script src="{{ asset('assets/vendors/countdown/countdown.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/owl-carousel/owl.carousel.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/bxslider/jquery.bxslider.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/bootstrap-select/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/vegas/vegas.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/jquery-ui/jquery-ui.js') }}"></script>
    <script src="{{ asset('assets/vendors/timepicker/timePicker.js') }}"></script>
    <script src="{{ asset('assets/vendors/circleType/jquery.circleType.js') }}"></script>
    <script src="{{ asset('assets/vendors/circleType/jquery.lettering.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/sidebar-content/jquery-sidebar-content.js') }}"></script>
    <script>
   $(document).ready(function(){
  $('.owl-carousel').each(function(){
    var $this = $(this);
    var options = $this.data('owl-options');
    if (typeof options === 'string') {
      options = JSON.parse(options);
    }
    $this.owlCarousel(options || {});
  });
});
    </script>





    <!-- template js -->
    <script src="{{ asset('assets/js/insuz.js') }}"></script>
</body>

</html>
