<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::table('submenus', function (Blueprint $table) {
            $table->dropForeign('submenus_menu_id_foreign'); // Drop old foreign key using constraint name
            $table->unsignedBigInteger('menu_id')->nullable()->change();
            $table->foreign('menu_id')->references('id')->on('menus')->onDelete('cascade');
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
