<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Page>
 */
class PageFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {

        return [
            'submenus_id' => 2,
            'title' => $this->faker->sentence,
            'short_description' => $this->faker->paragraph,
            'long_description' => $this->faker->paragraphs(3, true),
            'image' => $this->faker->imageUrl(640, 480, 'business', true),
            'video' => $this->faker->url,
            'meta_title' => $this->faker->sentence,
            'meta_description' => $this->faker->sentence,
            'meta_keywords' => $this->faker->words(3, true),
        ];
    }
}
