<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Submenu extends Model
{
    use  HasFactory;
    protected $table = 'submenus';
    protected $fillable = ['name', 'url', 'order', 'menu_id'];

    // Automatically load the "menu" relationship
    protected $with = ['section'];

    public function Menu() //  Ensure method name is lowercase
    {
        return $this->belongsTo(Menu::class, 'id');
    }

    public function section()
    {
        return $this->hasMany(Section::class, 'submenus_id');
    }
}
