<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title><?php echo $__env->yieldContent('title'); ?></title>

<!-- Stylesheets -->
<link href="<?php echo e(asset('assets/css/bootstrap.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/css/style.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/css/responsive.css')); ?>" rel="stylesheet">

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

<link rel="shortcut icon" href="<?php echo e(asset('assets/images/el-favicon.jpg')); ?>" type="image/x-icon">
<link rel="icon" href="<?php echo e(asset('assets/images/el-favicon.jpg')); ?>" type="image/x-icon">

<!-- line awesome -->
<link rel= "stylesheet" href= "https://maxst.icons8.com/vue-static/landings/line-awesome/line-awesome/1.3.0/css/line-awesome.min.css" >


<!-- Responsive -->
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

<!--[if lt IE 9]><script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.js"></script><![endif]-->
<!--[if lt IE 9]><script src="<?php echo e(asset('js/respond.js')); ?>"></script><![endif]-->


</head>

<body>

<div class="page-wrapper">

    <!-- Cursor -->
    <div class="cursor"></div>
    <div class="cursor-follower"></div>
    <!-- Cursor End -->

    <!-- Preloader -->
    <div class="preloader">
        <div class="box"></div>
    </div>

    <!-- Main Header / Header Style Two -->
    <header class="main-header header-style-two">

        <!-- Header Lower -->
        <div class="header-lower">
            <div class="auto-container">
                <div class="inner-container">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">

                        <!-- Logo Box -->
                        <div class="logo-box" style="max-width:20%;">
                            <div class="logo"><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('assets/images/el_roi-logo.png')); ?>" alt="" title="" style="max-width:100%;"></a></div>
                        </div>
                        <!-- End Logo Box -->

                        <!-- Nav Outer -->
                        <div class="nav-outer d-flex align-items-center flex-wrap">
                            <!-- Main Menu -->
                            <nav class="main-menu navbar-expand-md">
                                <div class="navbar-header">
                                    <!-- Toggle Button -->
                                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                    </button>
                                </div>

                                <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                                    <ul class="navigation clearfix">
                                        <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="<?php echo e($menu->type); ?>"><a href="<?php echo e($menu->url); ?>"><?php echo e($menu->name); ?></a>
                                            <?php if($menu->Submenus->count() > 0): ?>
                                                <ul>

                                                    <?php $__currentLoopData = $menu->submenus->sortBy('order', SORT_ASC); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($submenu->name =='Our People'): ?>
                                                    <li><a href="<?php echo e(url("$submenu->url")); ?>"><?php echo e($submenu->name); ?></a></li>

                                                   <?php elseif($submenu->name !=='Our People'): ?>
                                                    <li><a href="<?php echo e(url("$submenu->url/$submenu->id")); ?>"><?php echo e($submenu->name); ?></a></li>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            <?php endif; ?>
                                        </li>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                        <!-- End Nav Outer -->

                        <!-- Outer Box -->
                        <div class="outer-box d-flex align-items-center flex-wrap">

                            <!-- Header Options Box -->
                            <div class="header-options_box d-flex align-items-center">

                                <!-- Search Btn -->
                                <div class="search-box-btn search-box-outer"><span class="icon"><img src="<?php echo e(asset('assets/images/icons/search-light.svg')); ?>" alt="" /></span></div>

                                <!-- Nav Btn -->
                                <div class="nav-btn navSidebar-button">
                                    <i class="flaticon-dots-menu"></i>
                                </div>

                            </div>

                            <!-- Header Button Box -->
                            <div class="header_button-box">
                                <a href="<?php echo e(url('event-detail')); ?>" class="theme-btn btn-style-one">
                                    <span class="btn-wrap">
                                        <span class="text-one">Get a Quotes</span>
                                        <span class="text-two">Get a Quotes</span>
                                    </span>
                                </a>
                            </div>
                            <!-- Mobile Navigation Toggler -->
                            <div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
                        </div>
                        <!-- End Outer Box -->

                    </div>
                </div>
            </div>
        </div>
        <!-- End Header Lower -->

        <!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon flaticon-close-1"></span></div>

            <nav class="menu-box">
                <div class="nav-logo"><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('assets/images/el_roi-logo.png')); ?>" alt="" title=""></a></div>
                <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
            </nav>
        </div>
        <!-- End Mobile Menu -->

    </header>
    <!-- End Main Header -->

    <!-- Banner Two -->
    <section class="banner-two">
        <div class="banner-two_info"><a href="mailto:support@palace.com">support@palace.com</a> <span><a href="tel:+815-804-8928">815-804-8928</a></span></div>
        <div class="banner-two_socials">
            <a class="fa-brands fa-facebook-f fa-fw" href="#"></a>
            <a class="fa-brands fa-instagram fa-fw" href="#"></a>
            <a class="fa-brands fa-twitter fa-fw" href="#"></a>
            <a class="fa-brands fa-youtube fa-fw" href="#"></a>
        </div>
        <div class="banner-two_image" style="background-image:url(<?php echo e(asset('assets/images/main-slider/slide1.jpg')); ?>)"></div>
        <div class="auto-container">

            <!-- Content Column -->
            <div class="banner-two_content">
                <div class="banner-two_content-inner">
                    <div class="banner-two_title">real estate</div>
                    <h1 class="banner-two_heading">Let’s Unlock <br> <span>Dream Home </span>here</h1>
                    <div class="banner-two_text">Lorem ipsum dolor sit amet consectetur adipiscing elit Ut et massa mi. Aliquam in hendrerit urna. Pellentesque sit amet sapien fringilla, mattis ligula consectetur, ultrices mauris.</div>
                    <!-- Banner Tabs -->
                    <div class="banner-tabs">
                        <!-- Product Tabs -->
                        <div class="prod-tabs tabs-box">

                            <!-- Tab Btns -->
                            <ul class="tab-btns tab-buttons clearfix">
                                <li data-tab="#prod-buy" class="tab-btn active-btn">buy</li>
                                <li data-tab="#prod-rent" class="tab-btn">rent</li>
                                <li data-tab="#prod-sell" class="tab-btn">sell</li>
                            </ul>

                            <!-- Tabs Container -->
                            <div class="tabs-content">

                                <!-- Tab -->
                                <div class="tab active-tab" id="prod-buy">
                                    <div class="content">
                                        <!-- Default Form -->
                                        <div class="default-form">
                                            <form method="post" action="<?php echo e(url('contact')); ?>">
                                                <div class="row clearfix">

                                                    <div class="col-lg-4 col-md-4 col-sm-6 form-group">
                                                        <label>Location</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>Florida, Usa</option>
                                                            <option>Berlin</option>
                                                            <option>France</option>
                                                            <option>Pakistan</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-6 form-group">
                                                        <label>Type</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>20 x 10 Meters</option>
                                                            <option>30 x 20 Meters</option>
                                                            <option>40 x 30 Meters</option>
                                                            <option>50 x 40 Meters</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 form-group">
                                                        <label>Price Range</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>$700 - $900</option>
                                                            <option>$800 - $1000</option>
                                                            <option>$900 - $1100</option>
                                                            <option>$1000 - $1200</option>
                                                        </select>
                                                    </div>

                                                </div>
                                                <!-- Button Box -->
                                                <div class="button-box">
                                                    <button class="submit-btn">Search Now <i class="flaticon-search-interface-symbol"></i></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tab -->
                                <div class="tab" id="prod-rent">
                                    <div class="content">
                                        <!-- Default Form -->
                                        <div class="default-form">
                                            <form method="post" action="<?php echo e(url('contact')); ?>">
                                                <div class="row clearfix">

                                                    <div class="col-lg-4 col-md-4 col-sm-6 form-group">
                                                        <label>Location</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>Florida, Usa</option>
                                                            <option>Berlin</option>
                                                            <option>France</option>
                                                            <option>Pakistan</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-6 form-group">
                                                        <label>Type</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>20 x 10 Meters</option>
                                                            <option>30 x 20 Meters</option>
                                                            <option>40 x 30 Meters</option>
                                                            <option>50 x 40 Meters</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 form-group">
                                                        <label>Price Range</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>$700 - $900</option>
                                                            <option>$800 - $1000</option>
                                                            <option>$900 - $1100</option>
                                                            <option>$1000 - $1200</option>
                                                        </select>
                                                    </div>

                                                </div>
                                                <!-- Button Box -->
                                                <div class="button-box">
                                                    <button class="submit-btn">Search Now <i class="flaticon-search-interface-symbol"></i></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tab -->
                                <div class="tab" id="prod-sell">
                                    <div class="content">
                                        <!-- Default Form -->
                                        <div class="default-form">
                                            <form method="post" action="<?php echo e(url('contact')); ?>">
                                                <div class="row clearfix">

                                                    <div class="col-lg-4 col-md-4 col-sm-6 form-group">
                                                        <label>Location</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>Florida, Usa</option>
                                                            <option>Berlin</option>
                                                            <option>France</option>
                                                            <option>Pakistan</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-6 form-group">
                                                        <label>Type</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>20 x 10 Meters</option>
                                                            <option>30 x 20 Meters</option>
                                                            <option>40 x 30 Meters</option>
                                                            <option>50 x 40 Meters</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 form-group">
                                                        <label>Price Range</label>
                                                        <select name="country" class="custom-select-box">
                                                            <option>$700 - $900</option>
                                                            <option>$800 - $1000</option>
                                                            <option>$900 - $1100</option>
                                                            <option>$1000 - $1200</option>
                                                        </select>
                                                    </div>

                                                </div>
                                                <!-- Button Box -->
                                                <div class="button-box">
                                                    <button class="submit-btn">Search Now <i class="flaticon-search-interface-symbol"></i></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
	<!-- End Banner Two -->



    <?php echo $__env->yieldContent('content'); ?>




     <!-- Main Footer -->
     <footer class="main-footer style-two">
        <div class="main-footer_pattern" style="background-image: url(<?php echo e(asset('assets/images/background/footer-1.png')); ?>)"></div>
        <!-- Widgets Section -->
        <div class="widgets-section">
            <div class="auto-container">
                <div class="row clearfix">

                    <!-- Big Column -->
                    <div class="big-column col-lg-6 col-md-12 col-sm-12">
                        <div class="row clearfix">

                            <!-- Footer Column -->
                            <div class="footer_column col-lg-6 col-md-6 col-sm-12">
                                <div class="footer-widget">
                                    <div class="footer-logo"><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('assets/images/el_roi-logo.png')); ?>" alt="" title=""></a></div>
                                    <div class="footer-text">Lorem ipsum dolor sit amet consecte adipiscing elit Ut et massa mi. Aliquam  hendrerit urna.</div>
                                    <div class="footer-location">
                                        <div class="footer-location_inner">
                                            <i class="flaticon-maps-and-flags"></i> 1426 StreetBend,7702, California, USA
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Footer Column -->
                            <div class="footer_column col-lg-6 col-md-6 col-sm-12">
                                <div class="footer-widget links-widget">
                                    <h5 class="footer-title">Our Company</h5>
                                    <ul class="footer-list">
                                        <li><a href="<?php echo e(url('terms-of-use')); ?>">Terms of Use</a></li>
                                        <li><a href="<?php echo e(url('privacy-policy')); ?>">Privacy Policy</a></li>
                                        <li><a href="<?php echo e(url('pricing-plan')); ?>">Pricing Plan</a></li>
                                        <li><a href="<?php echo e(url('services')); ?>">Our Services</a></li>
                                        <li><a href="<?php echo e(url('contact')); ?>">Contact</a></li>
                                        <li><a href="<?php echo e(url('careers')); ?>">Careers</a></li>
                                        <li><a href="<?php echo e(url('faqs')); ?>">FAQS</a></li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>

                    <!-- Big Column -->
                    <div class="big-column col-lg-6 col-md-12 col-sm-12">
                        <div class="row clearfix">

                            <!-- Footer Column -->
                            <div class="footer_column col-lg-6 col-md-6 col-sm-12">
                                <div class="footer-widget links-widget">
                                    <h5 class="footer-title">Discover Cities</h5>
                                    <ul class="footer-list">
                                        <li><a href="<?php echo e(url('city/chicago')); ?>">Chicago</a></li>
                                        <li><a href="<?php echo e(url('city/los-angeles')); ?>">Los Angeles</a></li>
                                        <li><a href="<?php echo e(url('city/new-jersey')); ?>">New Jersey</a></li>
                                        <li><a href="<?php echo e(url('city/russia')); ?>">Russia</a></li>
                                        <li><a href="<?php echo e(url('city/south-africa')); ?>">South Africa</a></li>
                                        <li><a href="<?php echo e(url('city/canada')); ?>">Canada</a></li>
                                        <li><a href="<?php echo e(url('city/germany')); ?>">Germany</a></li>
                                    </ul>
                                </div>
                            </div>

                            <!-- Footer Column -->
                            <div class="footer_column col-lg-6 col-md-6 col-sm-12">
                                <div class="footer-widget subscribe-widget">
                                    <h5 class="footer-title">Subscribe Now!</h5>
                                    <!-- Newsletter Box -->
                                    <div class="newsletter-box">
                                        <form method="post" action="<?php echo e(url('subscribe')); ?>">
                                            <div class="form-group">
                                                <input type="email" name="search-field" value="" placeholder="Your Email" required>
                                                <button type="submit"><i class="flaticon-bell"></i></button>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- Social Box -->
                                    <div class="footer_socials">
                                        <a href="https://facebook.com/"><i class="fa-brands fa-facebook-f"></i></a>
                                        <a href="https://twitter.com/"><i class="fa-brands fa-twitter"></i></a>
                                        <a href="https://youtube.com/"><i class="fa-brands fa-youtube"></i></a>
                                        <a href="https://instagram.com/"><i class="fa-brands fa-instagram"></i></a>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>

            </div>
        </div>
        <!-- End Widgets Section -->

		<!-- Footer Bottom -->
		<div class="footer-bottom centered">
			<div class="auto-container">
				<div class="copyright">Copyright &copy; 2025 <?php date('Y')==2025?$till=' ':$till='- '.date('Y');
                 echo $till;
                    ?> <a href="#">El-Roi</a> All Rights Reserved<br> Designed by <a href='https://arkuzcreo.com'>ArkuzCreo</a></div>
			</div>
		</div>

	</footer>
	<!-- End Main Footer -->

	<!-- Search Popup -->
	<div class="search-popup">
		<div class="color-layer"></div>
		<button class="close-search"><span class="flaticon-close"></span></button>
		<form method="post" action="blog.html">
			<div class="form-group">
				<input type="search" name="search-field" value="" placeholder="Search Here" required="">
				<button class="fa fa-solid fa-magnifying-glass fa-fw" type="submit"></button>
			</div>
		</form>
	</div>
	<!-- End Search Popup -->

	<!-- Sidebar Cart Item -->
    <?php echo $__env->make('include.sidebar_cart', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</div>
<!-- End PageWrapper -->

<div class="progress-wrap">
	<svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
		<path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"/>
	</svg>
</div>

<script src="<?php echo e(asset('assets/js/jquery.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/appear.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/parallax.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/tilt.jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.paroller.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/wow.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/swiper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/backtotop.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/odometer.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/parallax-scroll.js')); ?>"></script>

<script src="<?php echo e(asset('assets/js/gsap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/SplitText.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/ScrollTrigger.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/ScrollToPlugin.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/ScrollSmoother.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/js/magnific-popup.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.meanmenu.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/nav-tool.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery-ui.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.countdown.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/element-in-view.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\El-Roi\el-roi\resources\views\layouts\master.blade.php ENDPATH**/ ?>