@extends('layouts.master')
@section('title', 'fast-growing property development company')
@section('content')


    <!-- About Section -->
    <<section class="about-section container bg-light rounded border" style="max-width: 80%; margin: auto; padding: 10px; background-color: #007336;">
        <div class="auto-container">
            <div class="row clearfix p-5">

                <!-- Objective Column -->
                <div class="team-block_one col-xl-4 col-lg-6 col-md-6 col-sm-6 position-relative">
                    <div class="about-inner">
                        {{-- <div class="about-icon">
                            <i class="fas fa-bullseye fa-2x text-center"></i> <!-- Font Awesome icon -->
                        </div> --}}
                        <h3 class="about-title">Objective <span class=""> <i class="fas fa-bullseye fa-2x" style="font-size:30px; color:#8b3c3a"></i> </span></h3>
                        <p class="about-text">Value Driven,Focused, Hardworking,innovative</p>
                    </div>
                    <!-- Vertical line (right) -->
                    <div class="position-absolute end-0 top-0 h-75 bg-dark" style="width: 1px; background-color: rgba(255,255,255,0.3);"></div>
                </div>

                <!-- Mission Column -->
                <div class="team-block_one col-xl-4 col-lg-6 col-md-6 col-sm-6 position-relative">
                    <div class="about-inner">
                        <h3 class="about-title">Mission <span class=""> <i class="fas fa-rocket fa-2x mx-auto" style="font-size:30px; color:#8b3c3a;"></i> </span></h3>
                        <p class="about-text">To help in unique ways that support high ethical standards in the development of property Investments in Nigeria.</p>
                    </div>
                    <!-- Vertical line (right) -->
                    <div class="position-absolute end-0 top-0 h-75 bg-dark" style="width: 1px; background-color: rgba(255,255,255,0.3);"></div>
                </div>

                <!-- Vision Column -->
                <div class="about-column col-lg-4 col-md-6 col-sm-12">
                    <div class="about-inner">
                        <h3 class="about-title">Vision<span class=""> <i class="fas fa-eye  fa-2x mx-auto" style="font-size:30px; color:#8b3c3a"></i> </span></h3>
                        <p class="about-text">To create affordable home for all.</p>
                    </div>
                </div>

            </div>
        </div>
    </section>
	<!-- Services One -->
    <section class="services-one">
        <div class="auto-container">
            <!-- Sec Title -->
            <div class="sec-title centered">
                <div class="sec-title_title">Our Services</div>
                <h2 class="sec-title_heading">Take a stroll around <br> surroundings.</h2>
            </div>
            <div class="three-items_slider swiper-container">
                <div class="swiper-wrapper">



                    <!-- Slide -->
                    @foreach($products->take(3) as $product)
                    <div class="swiper-slide">
                        <!-- Service Block One -->
                        <div class="service-block_one">
                            <div class="service-block_one-inner">
                                <div class="service-block_one_image" style='background-image:url({{ asset('assets/images/resource/service_1-1.jpg') }})'></div>
                                <div class="service-block_one-icon">
                                    {!!$product->icon!!}
                                </div>
                                <h4 class="service-block_one-heading"><a href="{{ url("service/$product->id") }}">{!!$product->name!!}</a></h4>
                                <div class="service-block_one-text">{!!Str::limit($product->content,200)!!}</div>
                                <a class="service-block_one-more" href="{{ url("service/$product->id") }}">Read More <i class="flaticon-next-1"></i></a>
                            </div>
                        </div>
                    </div>
                    @endforeach


                </div>

                <!-- If we need pagination -->
                <div class="three-items_slider-pagination"></div>

            </div>
        </div>
    </section>
	<!-- End Services One -->



	<!-- Faq One -->
    {{-- <section class="faq-one">
        <div class="auto-container">
            <div class="row clearfix">

                <!-- Image Column -->
                <div class="faq-one_accordion-column col-lg-6 col-md-12 col-sm-12">
                    <div class="faq-one_accordion-outer">

                        <!-- Accordion Box -->
                        <ul class="accordion-box">

                            <!-- Block -->
                            <li class="accordion block active-block">
                                <div class="acc-btn active"><div class="icon-outer"><span class="icon icon-plus flaticon-plus"></span></div>What is the difference between a Realtor速 & real estate?</div>
                                <div class="acc-content current">
                                    <div class="content">
                                        <div class="text">Closing costs typically range from 2% to 5% of the home's purchase price. These costs include lender fees, title insurance, appraisal fees, attorney fees, and prepaid items like property taxes and homeowners insurance.</div>
                                    </div>
                                </div>
                            </li>

                            <!-- Block -->
                            <li class="accordion block">
                                <div class="acc-btn"><div class="icon-outer"><span class="icon icon-plus flaticon-plus"></span></div>What factors should I consider when buying a home?</div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">Closing costs typically range from 2% to 5% of the home's purchase price. These costs include lender fees, title insurance, appraisal fees, attorney fees, and prepaid items like property taxes and homeowners insurance.</div>
                                    </div>
                                </div>
                            </li>

                            <!-- Block -->
                            <li class="accordion block">
                                <div class="acc-btn"><div class="icon-outer"><span class="icon icon-plus flaticon-plus"></span></div>How much should I budget for purchasing a home?</div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">Closing costs typically range from 2% to 5% of the home's purchase price. These costs include lender fees, title insurance, appraisal fees, attorney fees, and prepaid items like property taxes and homeowners insurance.</div>
                                    </div>
                                </div>
                            </li>

                            <!-- Block -->
                            <li class="accordion block">
                                <div class="acc-btn"><div class="icon-outer"><span class="icon icon-plus flaticon-plus"></span></div>What is a home appraisal, and why is it important?</div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">Closing costs typically range from 2% to 5% of the home's purchase price. These costs include lender fees, title insurance, appraisal fees, attorney fees, and prepaid items like property taxes and homeowners insurance.</div>
                                    </div>
                                </div>
                            </li>

                            <!-- Block -->
                            <li class="accordion block">
                                <div class="acc-btn"><div class="icon-outer"><span class="icon icon-plus flaticon-plus"></span></div>What is a home inspection, and should I get one?</div>
                                <div class="acc-content">
                                    <div class="content">
                                        <div class="text">Closing costs typically range from 2% to 5% of the home's purchase price. These costs include lender fees, title insurance, appraisal fees, attorney fees, and prepaid items like property taxes and homeowners insurance.</div>
                                    </div>
                                </div>
                            </li>

                        </ul>

                    </div>
                </div>

                <!-- Content Column -->
                <div class="faq-one_image-column col-lg-6 col-md-12 col-sm-12">
                    <div class="faq-one_image-outer">
                        <!-- Sec Title -->
                        <div class="sec-title">
                            <div class="sec-title_title">Discover Our Story</div>
                            <h2 class="sec-title_heading">Unveiling Palace  Real Estate Journey</h2>
                            <div class="sec-title_text">Lorem ipsum dolor sit amet consectetur adipiscing elit Ut et massa mi. Aliquam in hendrerit urna. Pellentesque sit amet sapien fringilla, mattis ligula consectetur, ultrices mauris.</div>
                        </div>
                        <div class="faq-one_image wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <img src="{{ asset('assets/images/resource/faq.jpg') }}" alt="" />
                        </div>
                        <a href="{{ url('live-chat') }}" class="faq-one_chat">
                            Live Chat <i><img src="{{ asset('assets/images/icons/chat-1.svg') }}" alt="" /></i>
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </section> --}}


<!-- End About Section -->

    <!-- End Faq One -->

            @include('include.mgmt_highlight')

<!-- About Section -->
<section class="about-section">
    <div class="auto-container">
        <div class="row clearfix"></div>

            <!-- Objective Column -->
            <div class="row clearfix">

                <!-- Image Column -->
                <div class="contact-two_image-column col-lg-6 col-md-12 col-sm-12">
                    <div class="contact-two_image-outer">
                        <div class="contact-two_image wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <img src="{{ asset('assets/images/resource/contact.jpg') }}" alt="" />
                        </div>
                        <!-- Phone Box -->
                        <div class="contact-two_phone">
                            <div class="contact-two_phone-inner">
                                <i class="flaticon-phone-call"></i>
                                Call Us Now! <br>
                                <a href="tel:+815-804-8928">{{$contact->mobile}}</a>
                            </div>
                        </div>

                        <div class="contact-two_image-content">
                            <i class="flaticon-home"></i>
                            <h5>Find the best deal</h5>
                            <div class="text">Get your Properties with Us!</div>
                        </div>

                    </div>
                </div>

                <!-- Content Column -->
                <div class="contact-two_content-column col-lg-6 col-md-12 col-sm-12">
                    <div class="contact-two_content-outer">
                        <!-- Sec Title -->
                        <div class="sec-title">
                            <div class="sec-title_title">contact with us</div>
                            <h2 class="sec-title_heading">reach out  to us !</h2>
                        </div>
                        <!-- Contact Form -->
                        <div class="contact-form">
                            <form method="POST" action="{{ url('/message') }}">
                                @csrf
                                <div class="form-group">
                                    <i class="flaticon-user"></i>
                                    <input type="text" name="username" placeholder="Full Name" required="">
                                </div>

                                <div class="form-group">
                                    <i class="flaticon-mail"></i>
                                    <input type="text" name="email" placeholder="Email Address" required="">
                                </div>

                                <div class="form-group">
                                    <i class="flaticon-telephone"></i>
                                    <input type="text" name="phone" placeholder="Phone Number" required="">
                                </div>

                                <div class="form-group">
                                    <textarea class="" name="message" placeholder="Type Here..."></textarea>
                                </div>
                                <div class="g-recaptcha" data-sitekey="{{ config('services.recaptcha.site_key') }}"></div>
                                <!-- Button Box -->
                                <div class="form-group">
                                    <button class="submit-btn" type="submit">Send Now</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End Contact Two -->

    <!-- Blog One -->
    {{-- <section class="blog-one">
        <div class="auto-container">
            <!-- Sec Title -->
            <div class="sec-title centered">
                <div class="sec-title_title">Our BLog</div>
                <h2 class="sec-title_heading">read  our latest blog</h2>
            </div>

            <div class="row clearfix">

                <!-- News Block One -->
                <div class="news-block_one style-two col-lg-4 col-md-6 col-sm-12">
                    <div class="news-block_one-inner">
                        <div class="news-block_one-image">
                            <a href="{{ url('blog-detail') }}"><img src="{{ asset('assets/images/resource/news-1.jpg') }}" alt="" /></a>
                        </div>
                        <div class="news-block_one-content">
                            <ul class="news-block_one-meta">
                                <li>By Admin</li>
                                <li>6 min read</li>
                            </ul>
                            <h4 class="news-block_one-title"><a href="{{ url('blog-detail') }}">Home buying 101 Essential best Tips.</a></h4>
                            <a class="news-block_one-more" href="{{ url('blog-detail') }}">Read More <i class="flaticon-next-1"></i></a>
                        </div>
                    </div>
                </div>

                <!-- News Block One -->
                <div class="news-block_one style-two col-lg-4 col-md-6 col-sm-12">
                    <div class="news-block_one-inner">
                        <div class="news-block_one-image">
                            <a href="{{ url('blog-detail') }}"><img src="{{ asset('assets/images/resource/news-2.jpg') }}" alt="" /></a>
                        </div>
                        <div class="news-block_one-content">
                            <ul class="news-block_one-meta">
                                <li>By Admin</li>
                                <li>6 min read</li>
                            </ul>
                            <h4 class="news-block_one-title"><a href="{{ url('blog-detail') }}">Finding Dream Home: Step by Step with us</a></h4>
                            <a class="news-block_one-more" href="{{ url('blog-detail') }}">Read More <i class="flaticon-next-1"></i></a>
                        </div>
                    </div>
                </div>

                <!-- News Block One -->
                <div class="news-block_one style-two col-lg-4 col-md-6 col-sm-12">
                    <div class="news-block_one-inner">
                        <div class="news-block_one-image">
                            <a href="{{ url('blog-detail') }}"><img src="{{ asset('assets/images/resource/news-3.jpg') }}" alt="" /></a>
                        </div>
                        <div class="news-block_one-content">
                            <ul class="news-block_one-meta">
                                <li>By Admin</li>
                                <li>6 min read</li>
                            </ul>
                            <h4 class="news-block_one-title"><a href="{{ url('blog-detail') }}">Selling Your Home: Quick Pro Tips now</a></h4>
                            <a class="news-block_one-more" href="{{ url('blog-detail') }}">Read More <i class="flaticon-next-1"></i></a>
                        </div>
                    </div>
                </div>

            </div>

		</div>
	</section> --}}
	<!-- End Blog One -->

    <!-- Cta One -->
    <section class="cta-one">
        <div class="auto-container">
            <div class="cta-one_inner-container d-flex justify-content-between align-items-center flex-wrap">
                <h1 class="cta-one_title end">let's talk <i><img src="{{ asset('assets/images/icons/arrow.png') }}" alt="" /></i></h1>
                <div class="cta-one_btn">
                    <a class="theme-btn" href="{{ url('contact') }}">Contact Us Now</a>
                </div>
            </div>
        </div>
    </section>
    <!-- End Cta One -->

 @endsection
