<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sections', function (Blueprint $table) {
            $table->dropForeign('sections_submenu_id_foreign'); // Drop old foreign key using constraint name
            $table->unsignedBigInteger('submenu_id')->nullable()->change();
            $table->foreign('submenu_id')->references('id')->on('submenus')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
       Schema::table('sections', function(Blueprint $table){
           $table->bigInteger('submenu_id')->nullable(false)->change();
       });
    }
};
